/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.services.utils;

import com.queplix.core.modules.services.jxb.Task;
import com.queplix.core.utils.dao.InterfaceDAO;

import java.util.Collection;

/**
 * Task DAO interface
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:01 $
 */

public interface TaskDAO
        extends InterfaceDAO {

    /**
     * Deletes Task record
     *
     * @param task Task object
     * @return number of deleted records
     */
    int deleteTaskVO(Task task);

    /**
     * Updates current Task record
     *
     * @param task Task object
     * @return number of updated records
     */
    int updateTaskVO(Task task);

    /**
     * Load task VO by its ID
     *
     * @param taskId task ID
     * @return Task object
     */
    Task loadTaskVO(long taskId);

    /**
     * Load task VO by its name
     *
     * @param taskName task name
     * @return Task object
     */
    Task loadTaskVO(String taskName);

    /**
     * Load All task VO
     *
     * @return Collection of Task objects
     */
    Collection loadAllTaskVO();
}
