/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.services.utils.log.impl;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.services.utils.log.AbstractLogRecord;
import com.queplix.core.modules.services.utils.log.Level;

/**
 * Mail LOG record value object.
 *
 * @author [ALB] Andrey Baranov
 * @version $Revision: 1.2 $ $Date: 2006/07/31 14:45:19 $
 */

public class MailLogRecord
        extends AbstractLogRecord {

    // ------------------------------------------------------- Fields

    // Sender class name
    private String senderClassName;
    private String referer;

    // ------------------------------------------------------- Constructor

    protected MailLogRecord(LogonSession ls,
                            Level level,
                            String message,
                            Throwable t,
                            Class sender,
                            String referer) {

        super(ls, level, (message == null) ? ((t != null) ? t.getMessage():null)
                :message);
        setCause(t);

        if(sender == null) {
            throw new NullPointerException("Sender class is NULL");
        }

        this.senderClassName = sender.getName();
        this.referer = referer;
    }

    // ------------------------------------------------------- Public methods

    public String getSenderClass() {
        return senderClassName;
    }

    public String getReferer() {
        return referer;
    }
    // ------------------------------------------------------- Public overrided methods

    /*
     * No javadoc
     * @see AbstractLogRecord#getHndClassName
     */

    public String getHndClassName() {
        return "com.queplix.core.modules.services.utils.log.impl.MailLogHandler";
    }
}
