/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.services.utils.log.impl;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.jeo.gen.ReportSchedulerObject;
import com.queplix.core.modules.services.utils.log.Level;

/**
 * Report Scheduler log publisher.
 *
 * @author [LIV] Ilya Ladnev
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:03 $
 */

public class ReportLogPublisher
        extends BaseLogPublisher {

    // ========================================================== Initialization

    /**
     * Constructor.
     *
     * @param ls logon session
     */
    public ReportLogPublisher(LogonSession ls) {
        super(ls);
    }

    // ========================================================== Public methods

    /* (non-Javadoc)
     * @see AbstractLogPublisher#ERROR(String)
     */

    public final void ERROR(String message) {
        ERROR(message, null);
    }

    /* (non-Javadoc)
     * @see AbstractLogPublisher#WARN(String)
     */
    public final void WARN(String message) {
        WARN(message, null);
    }

    /* (non-Javadoc)
     * @see AbstractLogPublisher#INFO(String)
     */
    public final void INFO(String message) {
        INFO(message, null);
    }

    /* (non-Javadoc)
     * @see AbstractLogPublisher#DEBUG(String)
     */
    public final void DEBUG(String message) {
        DEBUG(message, null);
    }

    /**
     * Logs an error message.
     *
     * @param message         message to log
     * @param reportScheduler ReportSchedulerObject
     */
    public final void ERROR(String message,
                            ReportSchedulerObject reportScheduler) {
        publish(message, reportScheduler, Level.ERROR);
    }

    /**
     * Logs a warning.
     *
     * @param message         message to log
     * @param reportScheduler ReportSchedulerObject
     */
    public final void WARN(String message,
                           ReportSchedulerObject reportScheduler) {
        publish(message, reportScheduler, Level.WARNING);
    }

    /**
     * Logs an informational message.
     *
     * @param message         message to log
     * @param reportScheduler ReportSchedulerObject
     */
    public final void INFO(String message,
                           ReportSchedulerObject reportScheduler) {
        publish(message, reportScheduler, Level.INFO);
    }

    /**
     * Logs a debug message.
     *
     * @param message         message to log
     * @param reportScheduler ReportSchedulerObject
     */
    public final void DEBUG(String message,
                            ReportSchedulerObject reportScheduler) {
        publish(message, reportScheduler, Level.DEBUG);
    }

    // ========================================================== Friend methods

    void publish(String message, ReportSchedulerObject reportScheduler,
                 Level level) {

        LogonSession ls = getLogonSession();
        long processID = getProcessID();
        ReportLogRecord lr = new ReportLogRecord(ls, level, message, processID,
                reportScheduler);
        publish(lr);
    }
}
