/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.services.utils.log.impl;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.jeo.gen.ReportSchedulerObject;
import com.queplix.core.modules.services.utils.log.Level;

/**
 * Report Scheduler LOG record value object.
 *
 * @author [LIV] Ilya Ladnev
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:03 $
 */

public class ReportLogRecord
        extends BaseLogRecord {

    // ------------------------------------------------------- Variables

    private ReportSchedulerObject reportScheduler;
    private long reportScheduleID;

    public static final int CLASS_ID = 9;

    // ------------------------------------------------------- Constructors

    public ReportLogRecord(LogonSession ls,
                           Level level,
                           String message,
                           long process_id) {
        this(ls, level, message, process_id, (ReportSchedulerObject) null);
    }

    public ReportLogRecord(LogonSession ls,
                           Level level,
                           String message,
                           long process_id,
                           ReportSchedulerObject reportScheduler) {
        super(ls, level, message, process_id);
        this.reportScheduler = reportScheduler;
    }

    // ------------------------------------------------------- Getters

    public final ReportSchedulerObject getReportSchedulerObject() {
        return reportScheduler;
    }

    // ------------------------------------------------------- Public overrided methods

    /*
     * No javadoc
     * @see BaseLogRecord#getClassId
     */

    public int getClassID() {
        return CLASS_ID;
    }

    /*
     * No javadoc
     * @see AbstractLogRecord#getHndClassName
     */
    public String getHndClassName() {
        return "com.queplix.core.modules.services.utils.log.impl.ReportLogHandler";
    }
}
