/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.cache;

import java.util.Properties;

/**
 * Abstract Cache.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:18 $
 */

public abstract class AbstractCache
        implements Cache {

    protected Properties prop;

    // Flag indicates openening cache.
    // Initially cache opened.
    private volatile boolean open = true;

    /*
     * No javadoc
     * @see Cache#setProperties
     */
    public void setProperties(Properties prop) {
        this.prop = prop;
    }

    /**
     * Property getter by the <code>name</code>.
     *
     * @param name String
     * @return Object
     */
    public Object getProperty(String name) {
        return prop == null ? null:prop.get(name);
    }

    /*
     * No javadoc
     * @see Cache#isOpen
     */
    public final boolean isOpen() {
        return open;
    }

    /*
     * No javadoc
     * @see Cache#open
     */
    public final boolean open() {
        boolean ret = this.open;
        this.open = true;
        return ret;
    }

    /*
     * No javadoc
     * @see Cache#close
     */
    public final void close() {
        this.open = false;
    }

    /*
     * No javadoc
     * @see Cache#clear
     */
    public void clear() {
        this.open = true;
    }
}
