/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.sql.parser;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;

/**
 * Interface describes time data parser.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:22 $
 */
public interface TimeParser
        extends SqlTypeParser {

    // Retrives object value from <code>ResultSet<code>.
    public Time getValue(ResultSet rs, int i)
            throws SQLException;

    // Retrives object value from <code>CallableStatement<code>.
    public Time getValue(CallableStatement cs, int i)
            throws SQLException;

    // Sets the object value into the <code>PreparedStement<code>.
    public void setValue(PreparedStatement stat, int pos, Time time)
            throws SQLException;

    /**
     * Build SQL date function AKA to_time.
     *
     * @param time Time object
     * @return sql function with parameter
     */
    public String sqlTimeFunction(Time time);
}
