/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.sql.vendor.jboss;

import com.queplix.core.utils.sql.vendor.oracle.BinaryParserOracleImpl;
import com.queplix.core.utils.sql.vendor.oracle.OracleBlob;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

/**
 * Oracle binary data (BLOB) parser JBOSS implementation.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1 $ $Date: 2005/03/04 10:45:27 $
 * @see BinaryParserOracleImpl
 */

public class BinaryParserOracleJBOSSImpl
        extends BinaryParserOracleImpl {

    // OracleBlob reference
    protected final OracleBlob ob = new OracleBlobJBOSSImpl();

    /* (non-Javadoc)
     * @see BinaryParser#getValue(ResultSet, int)
     */
    public byte[] getValue(ResultSet rs, int i) {
        return ob.getObject(rs, i);
    }

    /* (non-Javadoc)
     * @see BinaryParser#getValue(CallableStatement, int)
     */
    public byte[] getValue(CallableStatement cs, int i) {
        return ob.getObject(cs, i);
    }

    /* (non-Javadoc)
     * @see BinaryParser#getValue(PreparedStatement, int, byte[])
     */
    public void setValue(PreparedStatement stat, int pos, byte[] data) {
        ob.setObject(stat, pos, data);
    }
}
