/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.sql.vendor.jboss;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.utils.sql.vendor.oracle.OracleBlob;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.BLOB;
import org.jboss.resource.adapter.jdbc.WrappedCallableStatement;
import org.jboss.resource.adapter.jdbc.WrappedConnection;
import org.jboss.resource.adapter.jdbc.WrappedPreparedStatement;
import org.jboss.resource.adapter.jdbc.WrappedResultSet;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * This is a convenience class meant to generalize the action of updating an
 * BLOB column in an Oracle database.
 * This is JBOSS implementation. It checks SQL connection/statement/resultset
 * class if it's wrappeed and takes underlying object.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1 $ $Date: 2005/03/04 10:45:27 $
 * @see OracleBlob
 */
public class OracleBlobJBOSSImpl
        extends OracleBlob {

    // ========================================================== Public methods

    /*
     * No javadoc
     * @see OracleBlob#setObject
     */

    public void setObject(PreparedStatement stat, int pos, byte[] data) {

        if(stat instanceof WrappedPreparedStatement) {
            //stat = ( PreparedStatement ) ( ( WrappedPreparedStatement ) stat ).getUnderlyingStatement();
            try {
                stat = (PreparedStatement) ((WrappedPreparedStatement) stat)
                        .getUnderlyingStatement();
            } catch (SQLException e) {
                throw new GenericSystemException(
                        "SQL exception: " + e.getMessage(), e);
            }
        }
        if(!(stat instanceof oracle.jdbc.driver.OraclePreparedStatement)) {
            throw new IllegalStateException(
                    "Unexpected PreparedStatement class: " + stat.getClass());
        }

        super.setObject(stat, pos, data);
    }

    /*
     * No javadoc
     * @see OracleBlob#getObject
     */
    public byte[] getObject(ResultSet rs, int pos) {

        if(rs instanceof WrappedResultSet) {
            try {
                rs = ((WrappedResultSet) rs).getUnderlyingResultSet();
            } catch (SQLException ex) {
                throw new GenericSystemException(
                        "SQL exception: " + ex.getMessage(), ex);
            }
        }

        if(!(rs instanceof OracleResultSet)) {
            throw new IllegalStateException(
                    "Unexpected ResultSet class: " + rs.getClass());
        }

        return super.getObject(rs, pos);
    }

    /*
     * No javadoc
     * @see OracleBlob#getObject
     */
    public byte[] getObject(CallableStatement cs, int pos) {

        if(cs instanceof WrappedCallableStatement) {
            try {
                cs = (CallableStatement) ((WrappedCallableStatement) cs)
                        .getUnderlyingStatement();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        if(!(cs instanceof OracleCallableStatement)) {
            throw new IllegalStateException(
                    "Unexpected CallableStatement class: " + cs.getClass());
        }

        return super.getObject(cs, pos);
    }

    // ========================================================= Protected methods

    /*
     * No javadoc
     * @see OracleBlob#createBLOB
     */

    protected BLOB createBLOB(Connection conn, byte[] data) {

        if(conn instanceof WrappedConnection) {
            try {
                conn = ((WrappedConnection) conn).getUnderlyingConnection();
            } catch (SQLException ex) {
                throw new GenericSystemException(
                        "SQL exception: " + ex.getMessage(), ex);
            }
        }
        if(!(conn instanceof OracleConnection)) {
            throw new IllegalStateException(
                    "Unexpected Connection class: " + conn.getClass());
        }

        return super.createBLOB(conn, data);
    }

    /*
     * No javadoc
     * @see OracleBlob#freeBLOB
     */
    protected void freeBLOB(Connection conn, BLOB blob) {

        if(conn instanceof WrappedConnection) {
            try {
                conn = ((WrappedConnection) conn).getUnderlyingConnection();
            } catch (SQLException ex) {
                throw new GenericSystemException(
                        "SQL exception: " + ex.getMessage(), ex);
            }
        }
        if(!(conn instanceof OracleConnection)) {
            throw new IllegalStateException(
                    "Unexpected Connection class: " + conn.getClass());
        }

        super.freeBLOB(conn, blob);
    }
}
