/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.sql.vendor.jboss;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.utils.sql.vendor.oracle.OracleClob;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.CLOB;
import org.jboss.resource.adapter.jdbc.WrappedCallableStatement;
import org.jboss.resource.adapter.jdbc.WrappedConnection;
import org.jboss.resource.adapter.jdbc.WrappedPreparedStatement;
import org.jboss.resource.adapter.jdbc.WrappedResultSet;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * This is a convenience class meant to generalize the action of updating an
 * CLOB column in an Oracle database.
 * This is JBOSS implementation. It checks SQL connection/statement/resultset
 * class if it's wrappeed and takes underlying object.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1 $ $Date: 2005/03/22 08:05:49 $
 * @see OracleClob
 */
public class OracleClobJBOSSImpl
        extends OracleClob {

    // ========================================================== Public methods

    /*
     * No javadoc
     * @see OracleClob#setObject
     */

    public void setObject(PreparedStatement stat, int pos, char[] data) {

        if(stat instanceof WrappedPreparedStatement) {
            try {
                stat = (PreparedStatement) ((WrappedPreparedStatement) stat)
                        .getUnderlyingStatement();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        if(!(stat instanceof OraclePreparedStatement)) {
            throw new IllegalStateException(
                    "Unexpected PreparedStatement class: " + stat.getClass());
        }

        super.setObject(stat, pos, data);
    }

    /*
     * No javadoc
     * @see OracleClob#getObject
     */
    public char[] getObject(ResultSet rs, int pos) {

        if(rs instanceof WrappedResultSet) {
            try {
                rs = ((WrappedResultSet) rs).getUnderlyingResultSet();
            } catch (SQLException ex) {
                throw new GenericSystemException(
                        "SQL exception: " + ex.getMessage(), ex);
            }
        }

        if(!(rs instanceof OracleResultSet)) {
            throw new IllegalStateException(
                    "Unexpected ResultSet class: " + rs.getClass());
        }

        return super.getObject(rs, pos);
    }

    /*
     * No javadoc
     * @see OracleClob#getObject
     */
    public char[] getObject(CallableStatement cs, int pos) {

        if(cs instanceof WrappedCallableStatement) {
            try {
                cs = (CallableStatement) ((WrappedCallableStatement) cs)
                        .getUnderlyingStatement();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        if(!(cs instanceof OracleCallableStatement)) {
            throw new IllegalStateException(
                    "Unexpected CallableStatement class: " + cs.getClass());
        }

        return super.getObject(cs, pos);
    }

    // ========================================================= Protected methods

    /*
     * No javadoc
     * @see OracleClob#createCLOB
     */

    protected CLOB createCLOB(Connection conn, char[] data) {

        if(conn instanceof WrappedConnection) {
            try {
                conn = ((WrappedConnection) conn).getUnderlyingConnection();
            } catch (SQLException ex) {
                throw new GenericSystemException(
                        "SQL exception: " + ex.getMessage(), ex);
            }
        }
        if(!(conn instanceof OracleConnection)) {
            throw new IllegalStateException(
                    "Unexpected Connection class: " + conn.getClass());
        }

        return super.createCLOB(conn, data);
    }

    /*
     * No javadoc
     * @see OracleClob#freeCLOB
     */
    protected void freeCLOB(Connection conn, CLOB clob) {

        if(conn instanceof WrappedConnection) {
            try {
                conn = ((WrappedConnection) conn).getUnderlyingConnection();
            } catch (SQLException ex) {
                throw new GenericSystemException(
                        "SQL exception: " + ex.getMessage(), ex);
            }
        }
        if(!(conn instanceof OracleConnection)) {
            throw new IllegalStateException(
                    "Unexpected Connection class: " + conn.getClass());
        }

        super.freeCLOB(conn, clob);
    }
}
