/*
 * Copyright 2006 Pavel Jbanov.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.jpavel.gwt.wysiwyg.client;

import com.google.gwt.user.client.ui.FocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Frame;

public class EditorIframe extends Frame {
    
    public EditorIframe() {
        setStyleName("Editor-IFrame");
        
        sinkEvents(Event.MOUSEEVENTS);
        sinkEvents(Event.FOCUSEVENTS);
    }
    
    private List mouseOverListeners = new ArrayList();
    
    private List focusListeners = new ArrayList();
    
    public void addMouseOverListener(EditorMouseOverListener listener) {
        mouseOverListeners.add(listener);
    }
    
    public void removeMouseOverListener(EditorMouseOverListener listener) {
        mouseOverListeners.remove(listener);
    }

    public void addFocusListener(FocusListener listener) {
        focusListeners.add(listener);
    }
    
    public void removeFocusListener(FocusListener listener) {
        focusListeners.remove(listener);
    }
    
    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        switch (DOM.eventGetType(event)) {
            case Event.ONMOUSEOVER:
                for (Iterator i = mouseOverListeners.iterator(); i.hasNext(); ) {
                    ((EditorMouseOverListener) i.next()).onMouseOver(this);
                }
                break;
            case Event.ONFOCUS:
                for (Iterator i = focusListeners.iterator(); i.hasNext(); ) {
                    ((FocusListener) i.next()).onFocus(this);
                }
                break;
            case Event.ONBLUR:
                for (Iterator i = focusListeners.iterator(); i.hasNext(); ) {
                    ((FocusListener) i.next()).onLostFocus(this);
                }
                break;
        }
    }
}
