/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app;

import com.queplix.core.client.frames.mainframe.MainFrameBuilder;

/**
 * This interface should implements all the applications that behave like
 * gwt entry point and hold
 * {@link com.queplix.core.client.frames.mainframe.IMainFrame} functionality.
 * <p/>
 * That interface should be extended only for exceptional purposes,
 * because application by itself should not contain any representation
 * logic for the user.
 *
 * @author Sergey Kozmin
 * @since 10.04.2007
 */
public interface IApplication {
    /**
     * This method creates implementation of the
     * {@link com.queplix.core.client.frames.mainframe.MainFrameBuilder} that
     * provides all the functionality needed to customize (or implement)
     * needed QueWeb MainFrame fucntionality.
     *
     * @return implementation object of the main frame buidler.
     */
    public MainFrameBuilder createMainFrameBuilder();
}
