/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app;

import com.google.gwt.user.client.Timer;
import com.queplix.core.client.app.rpc.RPC;

/**
 * Idle Utilizer -- runs in background when the system is idle and performs
 * ahead-initialization to improve perfomance.
 *
 * @author Sultan Tezadov
 * @since 12 Mar 2007
 */
public abstract class IdleUtilizer {

    /**
     * Should be called when the user is prompted with login screen.
     */
    public static void onLoginPrompted() {
        (new Timer() {
            public void run() {
                RPC.getRPC().initLoginServiceAsync();
            }
        }).schedule(50); // let the browser to refresh before calling the method
    }

    /**
     * Should be called when the user has submitted login name and password
     * and the application is waiting for the server response.
     */
    public static void onLoginSubmitted() {
        (new Timer() {
            public void run() {
                RPC.getRPC().initDataServiceAsync();
            }
        }).schedule(50); // let the browser to refresh before calling the method
    }
}
