/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.rpc;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.queplix.core.client.app.vo.AccumulatedEntitiesRequestObject;
import com.queplix.core.client.app.vo.AdhocDeleteReportRequest;
import com.queplix.core.client.app.vo.AdhocPrintRequestObject;
import com.queplix.core.client.app.vo.AdhocSearchGridRecordsRequest;
import com.queplix.core.client.app.vo.BaseGridRequest;
import com.queplix.core.client.app.vo.ClearEntityRequestObject;
import com.queplix.core.client.app.vo.CustomizeGridRequestObject;
import com.queplix.core.client.app.vo.EmailComposeRequestObject;
import com.queplix.core.client.app.vo.EntityDeleteRequestObject;
import com.queplix.core.client.app.vo.EntityIDRequestObject;
import com.queplix.core.client.app.vo.EntityUpdateRequestObject;
import com.queplix.core.client.app.vo.FieldDataRequest;
import com.queplix.core.client.app.vo.FormatDataRequestObject;
import com.queplix.core.client.app.vo.MessageReadFlagRequest;
import com.queplix.core.client.app.vo.MetaData;
import com.queplix.core.client.app.vo.NewEntityRequestObject;
import com.queplix.core.client.app.vo.ParseDateRequestObject;
import com.queplix.core.client.app.vo.PortalCssRequest;
import com.queplix.core.client.app.vo.PrintFormRequestObject;
import com.queplix.core.client.app.vo.PrintGridRequestObject;
import com.queplix.core.client.app.vo.SaveAdhocReportRequestObject;
import com.queplix.core.client.app.vo.SavedSearchDeleteRequestObject;
import com.queplix.core.client.app.vo.SavedSearchObject;

/**
 * DataServiceAsync.
 *
 * @author Sultan Tezadov, Sergey Kozmin
 */
public interface DataServiceAsync {
    public void searchWithMultipleFormConstraints(
            AccumulatedEntitiesRequestObject multipleFormSearchRequest,
            AsyncCallback callback);

    public void getEntityData(EntityIDRequestObject searchRequest,
                              AsyncCallback async);

    public void getLockForEditRecord(EntityIDRequestObject searchRequest,
                                     AsyncCallback async);

    public void unlockAfterEditRecord(EntityIDRequestObject searchRequest,
                                      AsyncCallback async);

    public void updateRecord(EntityUpdateRequestObject updateRequest,
                             AsyncCallback async);

    public void createEntity(NewEntityRequestObject request,
                             AsyncCallback async);

    public void insertRecord(EntityUpdateRequestObject request,
                             AsyncCallback async);

    public void printForm(PrintFormRequestObject request, AsyncCallback async);

    public void printGrid(PrintGridRequestObject request, AsyncCallback async);

    public void saveSearch(SavedSearchObject search, AsyncCallback async);

    public void loadSavedSearches(AsyncCallback async);

    public void getMoreData(FieldDataRequest request, AsyncCallback callback);

    public void parseDate(ParseDateRequestObject parseRequest,
                          AsyncCallback callback);

    public void formatDate(FormatDataRequestObject request,
                           AsyncCallback callback);

    public void customizeGrid(CustomizeGridRequestObject request,
                              AsyncCallback callback);

    public void customEntitiesFieldsSearch(
            AdhocSearchGridRecordsRequest request, AsyncCallback callback);

    public void customEntitiesFieldsReport(AdhocPrintRequestObject request,
                                           AsyncCallback callback);

    public void saveReport(SaveAdhocReportRequestObject request,
                           AsyncCallback callback);

    public void loadReports(BaseGridRequest gridRequest,
                            AsyncCallback callback);

    public void loadReport(EntityIDRequestObject request,
                           AsyncCallback callback);

    public void deleteReport(AdhocDeleteReportRequest reportId,
                             AsyncCallback callback);

    public void deleteRecord(EntityDeleteRequestObject request,
                             AsyncCallback callback);

    public void saveSettings(MetaData metaData, AsyncCallback callback);

    public void deleteSavedSearch(SavedSearchDeleteRequestObject request,
                                  AsyncCallback callback);

    public void clearEntity(ClearEntityRequestObject request,
                            AsyncCallback callback);

    public void sendEmail(EmailComposeRequestObject request,
                          AsyncCallback callback);

    public void retrievePortalCss(PortalCssRequest request, AsyncCallback callback);
    
    public void setMessageReadFlag(MessageReadFlagRequest request, 
                                   AsyncCallback callback);

    public void hasUnreadMessages(AsyncCallback callback);
}
