/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.rpc;

/**
 * Displayable exception with stack trace information.
 *
 * @author Sultan Tezadov
 * @since 13 Dec 2006
 */
public class DisplayableStackTraceException extends DisplayableException {
    private String stringStackTrace;

    public DisplayableStackTraceException() {
    }

    public DisplayableStackTraceException(String message) {
        super(message);
    }

    public DisplayableStackTraceException(String message,
                                          String stringStackTrace) {
        super(message);
        this.stringStackTrace = stringStackTrace;
    }

    public String getStringStackTrace() {
        return stringStackTrace;
    }

    public void setStackTrace(String stringStackTrace) {
        this.stringStackTrace = stringStackTrace;
    }
}
