/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common;

import com.google.gwt.user.client.Element; 
import com.google.gwt.user.client.DOM;

/**
 * Helper which adds CSS files.
 * @author Dmitry Antonov
 * @since 14 Sep 2006
 */

public class CSSUtil {
    /**
    * Helper class to add a css element to the head of the document.
    * @param cssUrl The url of the css file.
    */
    public static void addCSS(String cssUrl) {
        if (cssUrl != null && cssUrl.length() != 0) {
            Element head = getElementByTagName("head");
            Element cssLink = DOM.createElement("link");
            setAttribute(cssLink, "type", "text/css");
            setAttribute(cssLink, "rel", "stylesheet");
            setAttribute(cssLink, "href", cssUrl);
            DOM.appendChild(head, cssLink);
        }
    }    
   
    private native static void setAttribute(Element el, String key, String val) /*-{
        el.setAttribute(key, val);
    }-*/;    
         
    private native static Element getElementByTagName(String tagName) /*-{
         var elem = $doc.getElementsByTagName(tagName);
         return elem ? elem[0] : null;
    }-*/; 
}
