/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common.ui;

import com.queplix.core.client.common.StringUtil;

/**
 * Helper functions for UI design
 *
 * @author Vasily Mikhailitchenko
 * @since: 8 Nov 2006
 */

public class DesignHelper {
    private final static String DIR_STACKPANEL = "stackpanel/";
    private final static String DIR_TABS = "tabs/";

    public static String stackPanelHeader(String string, String iconPostfix) {
        String html = "";
        html += "<table border=0 width='100%' cellpadding=0 cellspacing=0><tr>";
        html += "<td valign='middle'>" + StringUtil.imgSrc(
                DIR_STACKPANEL + "icon_" + iconPostfix + ".gif") + "</td>";
        html += "<td valign='middle' width='100%' class='treeStackHeader'> "
                + string + "</td>";
        html += "</tr></table>";
        return html;
    }
}
