/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * Represents "map" html element
 *
 * @author Michael Trofimov
 */
public class ImageMap extends ComplexPanel {

    private static ImageMapImpl impl;

    static {
        impl = (ImageMapImpl) GWT.create(ImageMapImpl.class);
    }

    public ImageMap() {
        super();
    }

    public ImageMap(String name) {
        this();
        setName(name);
    }

    public String getName() {
        return DOM.getAttribute(getElement(), "name");
    }

    public void setName(String name) {
        setElement(impl.createImageMapElement(name));
    }

    public ImageMapArea addArea(String shape, String coords) {
        ImageMapArea area = new ImageMapArea(shape, coords);
        super.add(area, getElement());
        return area;
    }

    public ImageMapArea addArea(String shape, String coords,
                                String targetHystoryToken) {
        ImageMapArea area = new ImageMapArea(shape, coords, targetHystoryToken);
        super.add(area, getElement());
        return area;
    }

    public boolean removeArea(ImageMapArea area) {
        return super.remove(area);
    }

    public void add(Widget w) {
        if(!(w instanceof ImageMapArea)) {
            throw new IllegalArgumentException("Unsupported argument type");
        }

        super.add(w);
    }

    public boolean remove(Widget w) {
        if(!(w instanceof ImageMapArea)) {
            throw new IllegalArgumentException("Unsupported argument type");
        }

        return super.remove(w);
    }

}
