/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common.ui;

import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseListenerAdapter;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesMouseEvents;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.queplix.core.client.common.event.Event;
import java.util.HashMap;
import java.util.Map;

/**
 * A set of label based buttons. Used in menues, etc.
 *
 * @author Sultan Tezadov
 * @since 27 Nov 2006
 */
public class LabelButtonSet extends ButtonSet implements SourcesMouseEvents {
    public static final String LABELED_BUTTON_STYLE
            = "labelbuttonset_label_style";

    private FocusPanel focusPanel;
    private Panel panel;
    private boolean horizontalLayout;
    private Map labelButtons = new HashMap();

    public LabelButtonSet(boolean horizontalLayout) {
        this(horizontalLayout, true);
    }

    public LabelButtonSet(boolean horizontalLayout, boolean initWidget) {
        focusPanel = new FocusPanel();
        this.horizontalLayout = horizontalLayout;
        if(horizontalLayout) {
            panel = new HorizontalPanel();
        } else {
            panel = new VerticalPanel();
        }
        focusPanel.setWidget(panel);
        if(initWidget) {
            initWidget(focusPanel);
        }
    }

    public void addButton(Event event, final ButtonData buttonData) {
        addButton(event, buttonData, true);
    }
    
    //todo change this - shall use internal form name instead of caption
    protected Label getLabelByEvent(Event event) {
        return (Label) labelButtons.get(event);
    }

    public void addButton(Event event, final ButtonData buttonData, boolean append) {
        final Label label = new Label(buttonData.getCaption());
        String title = buttonData.getTitle();
        labelButtons.put(event, label);
        if(title != null) {
            label.setTitle(title);
        }
        if(buttonData.hasCaptionStyle()) {
            label.addStyleName(buttonData.getCaptionStyle());
        }
        if(buttonData.hasCaptionHoverStyle()) {
            label.addMouseListener(new MouseListenerAdapter() {
                public void onMouseEnter(Widget sender) {
                    if(label.getStyleName().lastIndexOf(
                            buttonData.getCaptionSelectedStyle()) < 0) {
                        label.addStyleName(buttonData.getCaptionHoverStyle());
                    }
                }

                public void onMouseLeave(Widget sender) {
                    label.removeStyleName(buttonData.getCaptionHoverStyle());
                }
            });
        }
        label.addStyleName(LABELED_BUTTON_STYLE);
        addButton(event, label, append);
    }

    public void addButton(Event event, SourcesClickEvents widget) {
        addButton(event, widget, true);
    }
    
    public void addButton(Event event, SourcesClickEvents widget, boolean append) {
        Widget w = (Widget) widget;
        
        if(append) {
            super.addButton(event, widget, append);
            panel.add(w);
        } else {
            super.addButton(event, widget, false);
            if(horizontalLayout) {
                ((HorizontalPanel) panel).insert(w, 0);
            } else {
                ((VerticalPanel) panel).insert(w, 0);
            }
        }
    }

    public void removeAllButtons() {
        panel.clear();
        super.removeAllButtons();
    }

    public void removeButton(int index) {
        Event event = super.getEvent(index);
        panel.remove((Widget) getWidget(event));
        super.removeButton(index);
    }

    protected Panel getPanel() {
        return focusPanel;
    }

    public void addMouseListener(MouseListener listener) {
        focusPanel.addMouseListener(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        focusPanel.removeMouseListener(listener);
    }
}
