/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common.ui;

import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.queplix.core.client.common.event.Event;

/**
 * Tool Bar.
 *
 * @author Sultan Tezadov
 * @since 3 Dec 2006
 */
public class ToolBar extends ButtonSet implements ToolbarContext {
    private HorizontalPanel outerPanel;
    private HorizontalPanel leftPanel;
    private HorizontalPanel rightPanel;

    public ToolBar() {
        outerPanel = new HorizontalPanel();
        outerPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        outerPanel.addStyleName("toolbar_panel");
        initWidget(outerPanel);
    }

    public IconButton addButton(Event event, ButtonData buttonData,
                                boolean toLeft) {
        IconButton button = new IconButton(buttonData);
        super.addButton(event, button);
        button.addStyleName("toolbar_button");
        addToPanel(button, toLeft);
        return button;
    }

    public IconButton addMenuButton(Event event, ButtonData buttonData,
                                    boolean toLeft,
                                    EventButtonData[] menuItems) {
        IconButton button = addButton(event, buttonData, toLeft);
        MenuPopup menu = new MenuPopup(button);
        for(int i = 0; i < menuItems.length; i++) {
            EventButtonData item = menuItems[i];
            menu.addButton(item.getEvent(), item.getButtonData());
        }
        menu.getEventSource().addEventListener(
                getEventSource()); // retranslate events
        return button;
    }

    public Icon addIcon(IconData iconData, boolean toLeft) {
        Icon icon = new Icon(iconData);
        addToPanel(icon, toLeft);
        return icon;
    }

    /**
     * Makes two buttons visually appear close to each other thus making an
     * effect of a composite button. Used when creating buttons with
     * options like browser's Back and Forward buttons. To achive similar
     * effect merge a button created with <code>addButton()</code> with a
     * button created with <code>addMenuButton()</code>.
     */
    public void mergeButtons(IconButton first, IconButton second) {
        Panel parent = (Panel) first.getParent();
        first.removeFromParent();
        first.removeStyleName("toolbar_button");
        second.removeFromParent();
        second.removeStyleName("toolbar_button");
        HorizontalPanel panel = new HorizontalPanel();
        panel.add(first);
        panel.add(second);
        panel.addStyleName("toolbar_button");
        parent.add(panel);
    }

    private void addToPanel(Widget widget, boolean toLeft) {
        HorizontalPanel innerPanel = getInnerPanel(toLeft);
        innerPanel.add(widget);
    }

    private HorizontalPanel getInnerPanel(boolean left) {
        if(left) {
            if(leftPanel == null) {
                leftPanel = new HorizontalPanel();
                outerPanel.add(leftPanel);
                outerPanel.setCellHorizontalAlignment(leftPanel,
                        HasHorizontalAlignment.ALIGN_LEFT);
                leftPanel.setVerticalAlignment(
                        HasVerticalAlignment.ALIGN_MIDDLE);
            }
            return leftPanel;
        } else {
            if(rightPanel == null) {
                rightPanel = new HorizontalPanel();
                outerPanel.add(rightPanel);
                outerPanel.setCellHorizontalAlignment(rightPanel,
                        HasHorizontalAlignment.ALIGN_RIGHT);
                rightPanel.setVerticalAlignment(
                        HasVerticalAlignment.ALIGN_MIDDLE);
            }
            return rightPanel;
        }
    }

}
