/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.common.ui.grid;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.EventPreview;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.KeyboardListenerCollection;
import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.common.event.EventSource;

/**
 * Base class that is used in {@link com.queplix.core.client.common.ui.grid.DataGrid}
 *
 * @author Sergey Kozmin
 * @since 30.03.2007
 */
public abstract class BaseInternalDataGrid extends Grid
        implements SelectionController,
        EventPreview {
    // -------------------- public events ------------------------
    public static interface Events {
        Event/*]<Integer>[*/ GRID_ROW_SELECTED = new Event/*]<Integer>[*/();
        Event/*]<Integer>[*/ GRID_ROW_TO_BE_SELECTED
                = new Event/*]<Integer>[*/();
        Event/*]<Integer>[*/ SCROLL_TO_ROW = new Event/*]<Integer>[*/();
        Event DELETE_KEY_PRESSED = new Event();
    }

    private EventSource eventSource = new EventSource(this);

    public EventSource getEventSource() {
        return eventSource;
    }
    // ----------------- end of public events --------------------

    public void setFocus(boolean hasFocus) {
        if(hasFocus) {
            DOM.addEventPreview(this);
        } else {
            DOM.removeEventPreview(this);
        }
    }

    public boolean onEventPreview(com.google.gwt.user.client.Event e) {
        char keyCode = (char) DOM.eventGetKeyCode(e);
        int modifiers = KeyboardListenerCollection.getKeyboardModifiers(e);
        if(DOM.eventGetType(e) == com.google.gwt.user.client.Event.ONKEYDOWN) {
            onKeyDown(keyCode, modifiers);
        }
        if((keyCode == KeyboardListener.KEY_UP) || (keyCode == KeyboardListener
                .KEY_DOWN)) {
            // don't allow the event to bubble further to browser
            return false;
        } else {
            // the event is ok for the browser to process
            return true;
        }
    }

    public abstract void onKeyDown(char keyCode, int keyboardModifiers);

    public abstract void setupWidgets(GridModel model);

    public abstract void resizeColumn(int column, int width, int delta);

    public abstract void setupRow(GridModel model, int changedRow);

    public abstract void setupRows(GridModel model);

    public abstract void setHeaderGrid(HeaderGrid header);
}
