/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.common.ui.grid;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TableListener;
import com.google.gwt.user.client.ui.TableListenerCollection;
import com.google.gwt.user.client.ui.Widget;
import com.queplix.core.client.common.ui.ButtonData;
import com.queplix.core.client.common.ui.IconButton;

/**
 * Class, that should be changed in different browsers of {@link GridElementsStrategy}
 * <p/>
 * todo make this class abstract after all possible browser implementation will be implemented. Currently GWT doesn't allow to change absract class.
 *
 * @author Sergey Kozmin
 * @since 16.11.2006, 14:53:50
 */
public class GridElementsStrategyImpl implements GridElementsStrategy {
    private static final String IMG_PATH = "grid/";
    private static final String IMG_STYLE = "grid-HeaderRow_img";
    private TableListenerCollection listeners;

    public Widget getHeaderCell(final int cellIndex, Widget label,
                                Boolean sortBy) {
        FocusPanel fp = new FocusPanel();
        final HorizontalPanel hp = new HorizontalPanel();

        final String ASCENDING = "Ascending";
        final String DESCENDING = "Descending";
        final String UNSORTED = "Unsorted";

        final ButtonData ascSortState = new ButtonData(null, ASCENDING,
                IMG_PATH + "sort_asc.gif");
        final ButtonData descSortState = new ButtonData(null, DESCENDING,
                IMG_PATH + "sort_desc.gif");
        final ButtonData noSortState = new ButtonData(null, UNSORTED,
                IMG_PATH + "sort_none.gif");

        final IconButton icon = new IconButton(noSortState);

        if(sortBy != null) {
            boolean order = sortBy.booleanValue();
            icon.setButtonState(order ? ascSortState:descSortState);
            hp.setTitle(order ? ASCENDING:DESCENDING);
        } else {
            icon.setButtonState(noSortState);
            hp.setTitle(UNSORTED);
        }

        hp.add(label);
        hp.add(icon);

        hp.setCellWidth(label, "100%");
        hp.setCellHorizontalAlignment(label, HorizontalPanel.ALIGN_LEFT);
        hp.setCellHorizontalAlignment(icon, HorizontalPanel.ALIGN_RIGHT);
        hp.setWidth("100%");

        fp.addClickListener(new ClickListener() {
            public void onClick(Widget sender) {
                getListeners().fireCellClicked(GridElementsStrategyImpl.this, 0,
                        cellIndex);
            }
        });
        fp.setWidget(hp);
        return fp;
    }

    public Widget getHeaderCell(int cellIndex, String text, Boolean sortBy) {
        return getHeaderCell(cellIndex, new Label(text), sortBy);
    }

    public void setCellValue(Grid grid, int row, int column, String cellValue) {
    }

    public void setCellValue(Grid grid, int row, int column, Widget cellValue) {
    }

    public void setHeaderCellValue(Grid grid, int row, int column,
                                   String cellValue, Boolean sortBy) {
    }

    public void setHeaderColumnWidth(Grid grid, int column, int sizeInPixels,
                                     int delta) {
    }

    public void setOneRowColumnWidth(Grid grid, int row, int column,
                                     int sizeInPixels, int delta) {
    }

    public void setAllRowsColumnWidth(Grid grid, int column, int sizeInPixels,
                                      int delta) {
    }

    public void tableInitialized(Grid grid) {
    }

    public void addTableListener(TableListener listener) {
        getListeners().add(listener);
    }

    public void removeTableListener(TableListener listener) {
        getListeners().remove(listener);
    }

    private TableListenerCollection getListeners() {
        if(listeners == null) {
            listeners = new TableListenerCollection();
        }
        return listeners;
    }

}
