/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common.ui.grid;

import java.util.Iterator;
import java.util.Vector;


/**
 * Collection of GridSelectionModListeners
 *
 * @author Vasily Mikhailitchenko
 * @since 22 Dec 2006
 */
public class GridSelectionModListenerCollection extends Vector {

    public void fireSelectAll() {
        for(Iterator it = iterator(); it.hasNext();) {
            GridSelectionModListener listener = (GridSelectionModListener) it
                    .next();
            listener.onSelectAll();
        }
    }

    public void fireDeselectAll() {
        for(Iterator it = iterator(); it.hasNext();) {
            GridSelectionModListener listener = (GridSelectionModListener) it
                    .next();
            listener.onDeselectAll();
        }
    }

    public void fireInvertSelection() {
        for(Iterator it = iterator(); it.hasNext();) {
            GridSelectionModListener listener = (GridSelectionModListener) it
                    .next();
            listener.onInvertSelection();
        }
    }
}
