/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.common.ui.grid;

import java.util.ArrayList;

/**
 * Class implements factory pattern. This class
 * builds internal grid for the {@link com.queplix.core.client.common.ui.grid.DataGrid}
 * according to the requesting properties.
 *
 * @author Sergey Kozmin
 * @since 30.03.2007
 */
public class InternalGridFactory {
    /**
     * Builds internal grid.
     * More parameters to be added here.
     * <p/>
     * Doesn't support (!selfSelectionHandler && sendSelectionConfirmation).
     * Will be created (!selfSelectionHandler && !sendSelectionConfirmation) instead.
     *
     * @param selfSelectionHandler      should grid rely on external selection events
     *                                  handler or perform them by themself.
     * @param sendSelectionConfirmation should grid only send confirmation event
     *                                  to select some row, or select it without asking
     * @param view                      contains view params for data grid
     * @param strategy                  browser specified strategy for the grid behavior
     * @param gridListeners             grid listeners, in some cases they can be ignored
     * @return appropriate internal data grid implementation.
     */
    public static BaseInternalDataGrid createInternalGrid(GridView view,
                                                          GridElementsStrategy strategy,
                                                          ArrayList gridListeners,
                                                          boolean selfSelectionHandler,
                                                          boolean sendSelectionConfirmation) {
        BaseInternalDataGrid ret;
        if(selfSelectionHandler && !sendSelectionConfirmation) {
            ret = new SelectianableInternalGrid(view, strategy, gridListeners);
        } else if(selfSelectionHandler && sendSelectionConfirmation) {
            ret = new ConfirmableInternalGrid(view, strategy, gridListeners);
        } else {
            ret = new InternalDataGrid(view, strategy, gridListeners);
        }
        return ret;
    }
}
