/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.common.ui.grid;

import com.queplix.core.client.app.vo.GridData;
import com.queplix.core.client.app.vo.RowData;

/**
 * This is a facade pattern implementation for {@link com.queplix.core.client.common.ui.grid.GridDataProvider}
 *
 * @author Sergey Kozmin
 * @since 28.03.2007
 */
public class TextGridDataProvider implements GridDataProvider {
    private GridData data;
    private RowDataProviderImpl rowProvider;

    public TextGridDataProvider(GridData data) {
        this.data = data;
        rowProvider = new RowDataProviderImpl();
    }

    public int getRecordsCount() {
        return data != null ? data.getRows().length:0;
    }

    public RowDataProvider getRow(int row) {
        rowProvider.setRow(data.getRows()[row]);
        return rowProvider;
    }

    public void setData(GridData data) {
        this.data = data;
    }

    private static final class RowDataProviderImpl implements RowDataProvider {
        private RowData rowData;
        private CellDataProviderImpl cellProvider = new CellDataProviderImpl();

        public int getColumnsCount() {
            return rowData.getColumns().length;
        }

        public CellDataProvider getCell(int column) {
            cellProvider.setData(rowData.getColumns()[column]);
            return cellProvider;
        }

        public void setRow(RowData rowData) {
            this.rowData = rowData;
        }
    }

    private static final class CellDataProviderImpl
            implements CellDataProvider {
        private String data;

        public int getCellType() {
            return TEXT_TYPE;
        }

        public Object getCellInfo() {
            return data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}
