/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common.ui.resizable;

import com.google.gwt.user.client.ui.Label;
import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.FocusMeta;
import com.queplix.core.client.app.vo.SubFocusMeta;
import com.queplix.core.client.app.vo.TabMeta;

/**
 * Resizable lazy deck panel.
 *
 * @author Aliaksandr Melnik
 * @since 24 Oct 2006
 */
public abstract class ResizableLazyDeckPanel extends ResizableDeckPanel {
    public static final FamgMeta.Index DEFAULT_INDEX_TO_ACTIVATE
            = new FamgMeta.Index();
    protected FamgMeta.Index indexToActivate = DEFAULT_INDEX_TO_ACTIVATE;

    private boolean[] cardCreated;

    public ResizableLazyDeckPanel(int cardCount) {
        cardCreated = new boolean[cardCount];
        for(int i = 0; i < cardCount; i++) {
            add(new Label(), true);
        }
    }

    public void setIndexToActivate(FamgMeta.Index indexToActivate) {
        this.indexToActivate = indexToActivate;
    }

    public void setIndexToActivate(FocusMeta.Index indexToActivate) {
        FamgMeta.Index index = new FamgMeta.Index();
        index.focus = indexToActivate.focus;
        setIndexToActivate(index);
    }

    public void setIndexToActivate(SubFocusMeta.Index indexToActivate) {
        FamgMeta.Index index = new FamgMeta.Index();
        index.focus = indexToActivate.focus;
        index.subFocus = indexToActivate.subFocus;
        setIndexToActivate(index);
    }

    public void setIndexToActivate(TabMeta.Index indexToActivate) {
        FamgMeta.Index index = new FamgMeta.Index();
        index.focus = indexToActivate.focus;
        index.subFocus = indexToActivate.subFocus;
        index.tab = indexToActivate.tab;
        setIndexToActivate(index);
    }

    public void showWidget(int index) {
        if(!cardCreated[index]) {
            createCard(index);
            cardCreated[index] = true;
        }
        super.showWidget(index);
    }

    protected abstract void createCard(int index);

    public boolean isCardCreated(int index) {
        return cardCreated[index];
    }
}
