/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls;

/**
 * @author dmitry.antonov
 */
public final class QElementsCoupler {

    private static final QElementsCoupler instance = new QElementsCoupler();

    public static final int LEFT_ITEM = 1;
    public static final int RIGHT_ITEM = 2;

    public static QElementsCoupler getInstance() {
        return instance;
    }

    public void coupleElements(QFormLayoutElement leftElement,
                               QFormLayoutElement rightElement) {
        if(leftElement.canBeCoupled(LEFT_ITEM) &&
                rightElement.canBeCoupled(RIGHT_ITEM)) {
            leftElement.coupleElement(LEFT_ITEM);
            rightElement.coupleElement(RIGHT_ITEM);
        }
    }

}
