/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.controls.chart;

import com.queplix.core.client.app.vo.FieldData;
import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.common.event.EventSource;

/**
 * Chart controller
 *
 * @author Michael Trofimov
 */
public interface QChartController {

    static interface Events {
        Event CHART_REQUEST_DATA_EVENT = new Event();
        Event CHART_DRILLDOWN_CLICK_EVENT = new Event();
    }

    static interface ChartDrilldownClickEventData {
        /**
         * Full-qualified form id to perform search action
         */
        public String getFormId();

        /**
         * Returns array of form ids to apply filters.
         */
        public String[] getFilterFormIds();

        /**
         * Returns array of filters by form id.
         */
        public FieldData[] getFilters(String formId);
    }


    EventSource getEventSource();

}
