/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.controls.chart;

import com.queplix.core.client.app.vo.DateFieldData;
import com.queplix.core.client.app.vo.chart.ChartData;
import com.queplix.core.client.app.vo.chart.ChartMeta;
import com.queplix.core.client.app.vo.chart.ChartModel;

/**
 * Chart control model implementation
 * @author Michael Trofimov
 */
public class QChartModelImpl implements QChartModel {

    private ChartMeta meta;
    private ChartData data;

    transient private ModelListener listener;

    /**
     * GWT serialization constructor
     */
    public QChartModelImpl() {
    }

    public QChartModelImpl(ChartMeta meta) {
        this.meta = meta;
    }

    public QChartModelImpl(ChartModel model) {
        this.meta = model.getMeta();
        this.data = model.getData();
    }

    public void addListener(ModelListener listener) {
        this.listener = listener;
    }

    public ChartData getData() {
        return data;
    }

    public void setData(ChartData data) {
        this.data = data;
        fireDataChanged();
    }

    public ChartMeta getMeta() {
        return meta;
    }


    public void setMeta(ChartMeta meta) {
        this.meta = meta;
        fireMetaChanged();
    }

    /**
     * The descendants will override this method
     * to proper setup chart date range filter widget
     */
    public DateFieldData getDateFilter() {
        return null;
    }

    /**
     * The descendants will override this method
     * to proper setup chart "include closed" filter widget
     */
    public boolean isIncludeClosed() {
        return false;
    }

    protected void fireDataChanged() {
        if(listener != null) {
            listener.onDataChanged();
        }
    }

    protected void fireMetaChanged() {
        if(listener != null) {
            listener.onMetaChanged();
        }
    }

}
