package com.queplix.core.client.controls.charts;

import com.queplix.core.client.app.vo.ChartFieldMeta;
import com.queplix.core.client.app.vo.chart.ChartType;
import com.queplix.core.client.controls.QFormElement;
import com.queplix.core.client.controls.QFormElementController;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;
import com.queplix.core.client.i18n.I18N;

public class QChart implements QFormElement {

    private QChartModelImpl model;
    private QChartViewImpl view;
    private QChartControllerImpl controller;
    
    public QChart(ChartFieldMeta meta, int layout){
        model = new QChartModelImpl(meta);
        view = new QChartViewImpl(model, layout);
        controller = new QChartControllerImpl(model, view);
    }

    public static String getChartTypeTitle(ChartType type) {
        if(ChartType.BAR.equals(type)) {
            return I18N.getMessages().chartsBarChartLabel();
        }

        if(ChartType.PIE.equals(type)) {
            return I18N.getMessages().chartsPieChartLabel();
        }

        return null;
    }

    public QChartModel getModel() {
        return model;
    }

    public QChartView getView() {
        return view;
    }

    public QFormElementModel getBaseModel() {
        return model;
    }

    public QFormElementView getBaseView() {
        return view;
    }

    public QFormElementController getBaseController() {
        return controller;
    }

}
