/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.checkbox;

import com.queplix.core.client.app.vo.CheckBoxData;
import com.queplix.core.client.controls.QFormElementControllerImpl;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;

/**
 * Class represents Checkbox controller.
 *
 * @author Vasily Mikhailitchenko
 * @since 15.09.2006
 */
class QCheckBoxControllerImpl extends QFormElementControllerImpl implements
        QCheckBoxController,
        QCheckBoxViewImpl.UserActionsListener {
    private QCheckBoxViewImpl view;
    private QCheckBoxModelImpl model;

    public QCheckBoxControllerImpl(QCheckBoxViewImpl view,
                                   QCheckBoxModelImpl data) {
        this.view = view;
        this.model = data;

        this.view.addUserActionsListener(this);
    }

    public void onUserActions() {
        CheckBoxData cbd = this.model.getData();
        if(null == cbd.isChecked()) {
            cbd.setChecked(new Boolean(false));
        } else if(cbd.isChecked().booleanValue()) {
            if(view.isEditMode() || view.isNewMode()) {
                cbd.setChecked(new Boolean(false));
            } else {
                cbd.setChecked(null);
            }
        } else {
            cbd.setChecked(new Boolean(true));
        }
        this.model.setData(cbd);
    }

    public QFormElementModel getModel() {
        return this.model;
    }

    public QFormElementView getView() {
        return this.view;
    }
}
