/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.entitylink;

import com.queplix.core.client.app.vo.EntityLinkFieldMeta;
import com.queplix.core.client.controls.QFormElement;
import com.queplix.core.client.controls.QFormElementController;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;

/**
 * @author alexander.epifanov
 */
public class QEntityLink implements QFormElement {
//    public static final String ENTITYLINK_TRUE_IMAGE_PATH = "checkbox/checkbox_true.gif";
    //    public static final String ENTITYLINK_FALSE_IMAGE_PATH = "checkbox/checkbox_false.gif";
    //    public static final String ENTITYLINK_NULL_IMAGE_PATH = "checkbox/checkbox_null.gif";
    public static final String ENTITYLINK_IMAGE_STYLE = "image_button";

    private QEntityLinkControllerImpl controller;
    private QEntityLinkViewImpl view;
    private QEntityLinkModelImpl model;

    public QEntityLink(EntityLinkFieldMeta entityLinkFieldMeta) {
        model = new QEntityLinkModelImpl(entityLinkFieldMeta);
        view = new QEntityLinkViewImpl(model);
        controller = new QEntityLinkControllerImpl(model, view);
    }

    public QFormElementModel getBaseModel() {
        return model;
    }

    public QFormElementView getBaseView() {
        return view;
    }

    public QFormElementController getBaseController() {
        return controller;
    }
}
