/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.entitylink;

import com.queplix.core.client.app.vo.EntityLinkFieldData;
import com.queplix.core.client.app.vo.EntityLinkFieldMeta;
import com.queplix.core.client.app.vo.EntityLinkOnDemandData;
import com.queplix.core.client.controls.DataCloneException;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementModelImpl;

import java.util.Set;

/**
 * @author alexander.epifanov
 */
class QEntityLinkModelImpl extends QFormElementModelImpl
        implements QEntityLinkModel {
    public QEntityLinkModelImpl(EntityLinkFieldMeta entityLinkFieldMeta) {
        setMeta(entityLinkFieldMeta);
        setData(new EntityLinkFieldData(entityLinkFieldMeta.getFieldID()));
    }

    public void removeLinkedEntity(Long entityID) {
        Set ids = getData().getLinkedEntityIDs();
        ids.remove(entityID);
        fireModelDataChanged();
    }

    public void addLinkedEntity(Long entityID) {
        Set ids = getData().getLinkedEntityIDs();
        ids.add(entityID);
        fireModelDataChanged();
    }

    public EntityLinkFieldMeta getMeta() {
        if(null == super.getBaseMeta()) {
            setMeta(new EntityLinkFieldMeta());
        }
        return (EntityLinkFieldMeta) super.getBaseMeta();
    }

    public void setMeta(EntityLinkFieldMeta meta) {
        super.setBaseMeta(meta);
    }

    public EntityLinkFieldData getData() {
        if(null == super.getBaseData()) {
            setData(new EntityLinkFieldData());
        }
        return ((EntityLinkFieldData) super.getBaseData());
    }

    public EntityLinkOnDemandData getOnDemandData() {
        return (EntityLinkOnDemandData) getFieldOnDemandData();
    }

    public void setData(EntityLinkFieldData data) {
        super.setBaseData(data);
    }

    public boolean isValid() {
        return !(getMeta().isRequired() && getData().isEmpty());
    }

    public int getDataType() {
        return THE_TYPE;
    }

    public void cloneDataFrom(QFormElementModel sameTypeControlModel)
            throws DataCloneException {
        if(THE_TYPE != sameTypeControlModel.getDataType()) {
            throw new DataCloneException("Could not clone data for "
                    + THE_TYPE + ", from " + sameTypeControlModel
                    .getDataType());
        }
        QEntityLinkModel model = (QEntityLinkModel) sameTypeControlModel;
        this.setData((EntityLinkFieldData) model.getData().cloneData());
    }

    public boolean isLinkable() {
        return true;
    }
}
