/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.form;

import com.queplix.core.client.app.vo.FieldOnDemandData;

/**
 * To be called when QForm data is changed
 *
 * @author Sergey Kozmin
 * @since 26.09.2006, 18:54:39
 */
interface QFormDataListener {
    /**
     * To be called when structure of the data is changed
     */
    public void dataStructureChanged();

    /**
     * To be called when data for the element is changed.
     *
     * @param elementId changed element id
     */
    public void dataChanged(String elementId);

    public void dataOnDemandCome(FieldOnDemandData data);
}
