/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.form;

import com.queplix.core.client.app.vo.ContextMenuMeta;
import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.FieldData;
import com.queplix.core.client.app.vo.FieldMeta;
import com.queplix.core.client.app.vo.FieldOnDemandData;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Represents form model
 *
 * @author Sergey Kozmin
 * @since 21.09.2006, 17:47:08
 */
public interface QFormModel {
    /**
     * no need unique id, but in case of error.
     */
    public static final int SEARCH_NEUTRAL = 0;
    public static final int SEARCH_SUCCESSFUL_SINGLE = 1;
    //    public static final int SEARCH_SUCCESSFUL_MULTIPLE = 2;
    public static final int SEARCH_FAILED = 3;

    public static final int UPDATE_NEUTRAL = 4;
    public static final int UPDATE_SUCCESSFUL = 5;
    public static final int UPDATE_FAILED = 6;

    public static final int LOCK_FOR_EDIT_NEUTRAL = 7;
    public static final int LOCK_FOR_EDIT_SUCCESSFUL = 8;
    public static final int LOCK_FOR_EDIT_FAILED = 9;

    public static final int DELETE_NEUTRAL = 10;
    public static final int DELETE_SUCCESSFUL = 11;
    public static final int DELETE_FAILED = 12;

    public static final int NEW_NEUTRAL = 13;
    public static final int NEW_SUCCESSFUL = 14;
    public static final int NEW_FAILED = 15;

    public static final boolean NOTIFY = true;
    public static final boolean WITHOUT_NOTIFICATION = false;

    /**
     * @return ArrayList of the elementID's. Do not modify it
     */
    public ArrayList elementsKeys();

    /**
     * @return new collection copy from the elements values. Collection<FieldData>
     */
    public Collection elementsValues();

    public FieldMeta getElementMeta(String elementID);

    public void clearElementData(String elementID);

    public ContextMenuMeta getContextMenuMeta();

    public void setOnDemandDataForElement(FieldOnDemandData data);

    /**
     * Set data for the given element
     * Generates update event if data is changed.
     *
     * @param data element data. Ignored if object is null.
     */
    public void setDataForElement(FieldData data);

    /**
     * Set data for the given elements
     * Generate update event.
     *
     * @param data elements data array
     */
    public void setDataForElements(FieldData[] data, boolean clearRestElements);

    public FieldData getElementData(String elementID);

    public void clearActiveRowID();

    public void setActiveRowID(Long rowID);

    /**
     * If returned id is null, than this form doesn't contain the record.
     *
     * @return active row id.
     */
    public Long getActiveRowID();

    /**
     * This method is slower compared to {@link #elementsValues()} because it
     * notifies event-listener to upload data from controls to model.
     *
     * @return non-empty elementes filters. List<FieldData>
     */
    public List getNonEmptyFilters();

    public String getFormTitle();

    public void setFormTitle(String formTitle);

    /**
     * @return current state of form. States can be found {@link com.queplix.core.client.controls.form.QFormState}
     * @see com.queplix.core.client.controls.form.QFormState
     */
    public int getFormState();

    /**
     * Trig search state. As soon as it will be triggered it fires internal events and return to neutral state.
     *
     * @param searchFinished new search state.
     */
    public void setSearchState(int searchFinished);

    public void setLockForEditState(int lockForEditSuccess);

    public void setDataUpdatedState(int dataUpdatedSuccess);

    public void setCreateState(int createFinished);

    public void setDeleteState(int deleteFinished);

    public String getRecordDescription();

    public FamgMeta.Index getIndex();

    public String getPkeyID();

    public String getEntityID();
}
