/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.form;

import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.frames.mainframe.FormState;

/**
 * Form state interface
 *
 * @author Sergey Kozmin
 * @since 29.09.2006, 16:12:22
 */
interface QFormState extends FormState {
    /**
     * @return state constant, that determine this state.
     */
    public int getState();

    /**
     * Method is called when form enters to this state
     *
     * @param previusState
     */
    public void enterToState(int previusState);

    /**
     * This method is called when form exits from this state.
     */
    public void exitFromState();

    /**
     * This method is called when action is perfomed.
     *
     * @param action the action to be perfomed by current state
     * @throws IncorrectFormActionPerformed thrown if the action has unknow type
     */
    public void actionPerformed(Event action)
            throws IncorrectFormActionPerformed;

    /**
     * @return can form exit from state.
     */
    public boolean canFromExitState();

    /**
     * by this method state reset its internal state to initial one.
     */
    public void resetState();
}
