/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.grid;

import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.common.event.EventSource;
import com.queplix.core.client.common.ui.grid.BaseInternalDataGrid;
import com.queplix.core.client.common.ui.grid.SelectedRecord;

import java.util.List;

// TODO: once generics enabled, remove all occurences of '/*]' and '[*/'
public interface QGridController {
    // -------------------- public events ------------------------
    public static interface Events {
        /**
         * Grid colums customize event.
         * Event data passed along with it is of type
         * com.queplix.core.client.app.vo.SubsetData
         */
        Event/*]<SubsetData>[*/ GRID_CUSTOMIZE = new Event/*]<SubsetData>[*/();
        Event GRID_REFRESH = new Event();
        Event GRID_PRINT = new Event();
        Event GRID_EXPORT_TO_WORD = new Event();
        Event GRID_EXPORT_TO_EXCEL = new Event();
        Event GRID_NEED_DATA = new Event();
        Event GRID_COLUMN_SELECTED = new Event();

        Event/*]<Long>[*/ RECORD_SELECTED = new Event/*]<Long>[*/();
        Event/*]<Long>[*/ RECORD_TO_BE_SELECTED = new Event/*]<Long>[*/();
        Event DELETE_KEY_PRESSED
                = BaseInternalDataGrid.Events.DELETE_KEY_PRESSED;
    }
    

    public static final class SelectedRecordImpl implements SelectedRecord {
        private final Long recordId;
        private final FamgMeta.Index index;
        public SelectedRecordImpl(Long recordId, FamgMeta.Index index) {
            this.recordId = recordId;
            this.index = index;
        }
        public Long getRecordId() {
            return recordId;
        }
        public FamgMeta.Index getIndex() {
            return index;
        }
    }

    public EventSource getEventSource();
    // ----------------- end of public events --------------------

    public void clearSelectedRecord();

    public void clearGrid();

    public void collectUISettings();

    /**
     * @return List<Long>
     */
    public List getMarkedRecordsIds();
}
