/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.controls.grid;

import com.google.gwt.user.client.ui.Widget;
import com.queplix.core.client.app.vo.FieldMeta;
import com.queplix.core.client.app.vo.GridMeta;
import com.queplix.core.client.app.vo.SubsetData;
import com.queplix.core.client.app.vo.SubsetItemMeta;
import com.queplix.core.client.app.vo.SubsetMeta;
import com.queplix.core.client.common.StringUtil;
import com.queplix.core.client.common.event.EventSource;
import com.queplix.core.client.common.ui.ButtonData;
import com.queplix.core.client.common.ui.IconButton;
import com.queplix.core.client.common.ui.OkayCancelPopup;
import com.queplix.core.client.common.ui.subsetselect.ListboxSubsetSelect;
import com.queplix.core.client.i18n.I18N;

/**
 * Grid columns customizer.
 *
 * @author Sultan Tezadov
 * @since 18 Nov 2006
 */
class QGridCustomizer extends IconButton {
    private OkayCancelPopup dialog;
    private ListboxSubsetSelect subset;

    private GridMeta gridMeta;
    private EventSource eventSource;

    public QGridCustomizer(GridMeta gridMeta) {
        super(new ButtonData(null, I18N.getMessages().customizeGrid(),
                "grid/customize.gif", null, "grid/customize_bright.gif"));
        this.gridMeta = gridMeta;
        eventSource = new EventSource(this);
    }

    public void onClick(Widget sender) { // overriden
        showDialog();
    }

    private void initDialog() {
        if(dialog == null) {
            dialog = new OkayCancelPopup(
                    I18N.getMessages().addRemoveGridColumns());
            int offsetHeight = dialog.getOffsetHeight();
            dialog.setHeight(StringUtil.pixelToSize(offsetHeight));
            dialog.addStyleName("customizer_dialog");
            subset = new ListboxSubsetSelect();
            dialog.getEventSource().addEventListener(
                    eventSource); // retranslate events
            dialog.setWidget(subset);
        }
    }

    private void populateData() {
        FieldMeta[] fields = gridMeta.getFields();
        int n = 0;
        for(int i = 0; i < fields.length; i++) {
            if(fields[i].isForGrid()) {
                n++;
            }
        }
        SubsetItemMeta[] sim = new SubsetItemMeta[n];
        int j = 0;
        for(int i = 0; i < fields.length; i++) {
            if(fields[i].isForGrid()) {
                sim[j] = new SubsetItemMeta(i, fields[i].getCaption());
                j++;
            }
        }

        subset.setMeta(new SubsetMeta(sim));
        subset.setData(gridMeta.cloneColumns());
    }

    private void showDialog() {
        initDialog();
        populateData();
        dialog.show(this);
    }

    SubsetData getSubsetData() {
        return subset.getData();
    }

    EventSource getEventSource() {
        return eventSource;
    }

}
