/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.informgrid;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Widget;

/**
 * General class for common form action button.
 *
 * @author Sergey Kozmin
 * @since 29.09.2006, 16:54:54
 */
class CommonActionButton extends Button implements ClickListener {
    private static final String COMMON_ACTION_STYLE = QInformGrid
            .INFORMGRID_STYLE_NAME_PREFIX + "commonAction";
    private int commonButton;
    private CommonActionListener listener;

    public CommonActionButton(String html, int commonButton,
                              CommonActionListener listener) {
        super(html);
        this.commonButton = commonButton;
        this.listener = listener;
        addClickListener(this);
        setStyleName(COMMON_ACTION_STYLE);
    }

    public void onClick(Widget sender) {
        listener.fireCommonActionPerformed(commonButton);
    }

    public int getCommonButton() {
        return commonButton;
    }

    public void setCommonButton(int commonButton) {
        this.commonButton = commonButton;
    }
}
