/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.informgrid;

/**
 * In-Form grid state interface
 *
 * @author Sergey Kozmin
 * @since 29.09.2006, 16:12:22
 */
interface QInformGridState {
    public static final int SEARCH_STATE = 0;
    public static final int SELECTED_STATE = 1;
    public static final int EDIT_STATE = 2;

    public int getState();

    public void enterToState();

    /**
     * By calling this method client code notify state that some action is performed.
     * {@link QInformGridState#SEARCH_STATE} is performed
     *
     * @param action action identifier. See {@link QInformGridState#SEARCH_STATE} for example
     * @throws IncorrectGridActionPerformed if some incorrect action was performed by state.
     */
    public void actionPerformed(int action) throws IncorrectGridActionPerformed;

    public void exitFromState();
}

