/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.memo;

import com.queplix.core.client.app.vo.MemoFieldMeta;
import com.queplix.core.client.controls.QFormElement;
import com.queplix.core.client.controls.QFormElementController;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;

/**
 * @author: Vasily Mikhailitchenko
 * @since: 15.09.2006
 */
public class QMemo implements QFormElement {
    public static final String BUTTON_EMPTY_IMAGE_PATH = "memo/button1.gif";
    public static final String BUTTON_FULL_IMAGE_PATH = "memo/button2.gif";

    public static final String BUTTON_CSS_STYLE = "simple_button";

    private QMemoModelImpl model;
    private QMemoViewImpl view;
    private QMemoControllerImpl controller;

    public QMemo(MemoFieldMeta fieldMeta, int layout) {
        // setting some draggable caption
        model = new QMemoModelImpl(fieldMeta);
        view = QMemoViewImpl.createInstance(model, layout);
        controller = new QMemoControllerImpl(model, view);
    }

    public QMemoModel getModel() {
        return model;
    }

    public QMemoView getView() {
        return view;
    }

    public QMemoController getController() {
        return controller;
    }

    public QFormElementView getBaseView() {
        return view;
    }

    public QFormElementController getBaseController() {
        return controller;
    }

    public QFormElementModel getBaseModel() {
        return model;
    }
}

