/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.memo;

import com.queplix.core.client.app.vo.MemoFieldData;
import com.queplix.core.client.app.vo.MemoFieldMeta;
import com.queplix.core.client.controls.DataCloneException;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementModelImpl;

import java.util.ArrayList;

/**
 * @author: Vasily Mikhailitchenko
 * @since: 15.09.2006
 */
class QMemoModelImpl extends QFormElementModelImpl implements QMemoModel {
    private ArrayList changeListeners = new ArrayList();

    public QMemoModelImpl(MemoFieldMeta fieldMeta) {
        setMeta(fieldMeta);
        setData(new MemoFieldData(fieldMeta.getFieldID()));
    }

    public MemoFieldMeta getMeta() {
        if(null == super.getBaseMeta()) {
            setMeta(new MemoFieldMeta());
        }
        return (MemoFieldMeta) super.getBaseMeta();
    }

    public void setMeta(MemoFieldMeta meta) {
        super.setBaseMeta(meta);
    }

    public MemoFieldData getData() {
        if(null == super.getBaseData()) {
            setData(new MemoFieldData());
        }
        return ((MemoFieldData) super.getBaseData());
    }

    public void setData(MemoFieldData data) {
        super.setBaseData(data);
    }

    public void addDataChangeListener(QMemoListener listener) {
        changeListeners.add(listener);
    }

    public void removeDataChangeListener(QMemoListener listener) {
        changeListeners.remove(listener);
    }

    protected void fireDataChanged() {
        for(int i = 0; i < changeListeners.size(); i++) {
            QMemoListener listener = (QMemoListener) changeListeners.get(i);
            listener.dataChanged();
        }
    }

    public boolean isValid() {
        if(getMeta().isRequired() && getData().isEmpty()) {
            return false;
        } else {
            return true;
        }
    }

    public int getDataType() {
        return THE_TYPE;
    }

    public void cloneDataFrom(QFormElementModel sameTypeControlModel)
            throws DataCloneException {
        if(THE_TYPE != sameTypeControlModel.getDataType()) {
            throw new DataCloneException("Could not clone data for "
                    + THE_TYPE + ", from " + sameTypeControlModel
                    .getDataType());
        }
        QMemoModel model = (QMemoModel) sameTypeControlModel;
        setData((MemoFieldData) model.getData().cloneData());
    }

    public boolean isLinkable() {
        return true;
    }
}
