/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.textarea;

import com.queplix.core.client.app.vo.TextareaFieldData;
import com.queplix.core.client.app.vo.TextareaFieldMeta;
import com.queplix.core.client.common.StringUtil;
import com.queplix.core.client.controls.DataCloneException;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementModelImpl;

import java.util.ArrayList;

class QTextAreaModelImpl extends QFormElementModelImpl
        implements QTextAreaModel {
    private ArrayList changeListeners = new ArrayList();

    public QTextAreaModelImpl(TextareaFieldMeta textareaFieldMeta) {
        setMeta(textareaFieldMeta);
        setData(new TextareaFieldData(textareaFieldMeta.getFieldID()));
    }

    public TextareaFieldMeta getMeta() {
        if(null == super.getBaseMeta()) {
            setMeta(new TextareaFieldMeta());
        }
        return (TextareaFieldMeta) super.getBaseMeta();
    }

    public void setMeta(TextareaFieldMeta meta) {
        super.setBaseMeta(meta);
    }

    public TextareaFieldData getData() {
        if(null == super.getBaseData()) {
            setData(new TextareaFieldData());
        }
        return ((TextareaFieldData) super.getBaseData());
    }

    public void setData(TextareaFieldData data) {
        data.setText(StringUtil.nullToEmpty(data.getText()));
        super.setBaseData(data);
    }

    public ArrayList getChangeListeners() {
        return changeListeners;
    }

    public void setChangeListeners(ArrayList changeListeners) {
        this.changeListeners = changeListeners;
    }

    public void addDataChangeListener(QTextAreaChangeListener listener) {
        changeListeners.add(listener);
    }

    public void removeDataChangeListener(QTextAreaChangeListener listener) {
        changeListeners.remove(listener);
    }

    protected void fireDataChanged() {
        for(int i = 0; i < changeListeners.size(); i++) {
            QTextAreaChangeListener listener
                    = (QTextAreaChangeListener) changeListeners.get(i);
            listener.dataChanged();
        }
    }

    public boolean isValid() {
        return !(getMeta().isRequired() && getData().isEmpty());
    }

    public int getDataType() {
        return THE_TYPE;
    }

    public void cloneDataFrom(QFormElementModel sameTypeControlModel)
            throws DataCloneException {
        if(THE_TYPE != sameTypeControlModel.getDataType()) {
            throw new DataCloneException("Could not clone data for "
                    + THE_TYPE + ", from " + sameTypeControlModel
                    .getDataType());
        }
        QTextAreaModel model = (QTextAreaModel) sameTypeControlModel;
        setData((TextareaFieldData) model.getData().cloneData());
    }

    public boolean isLinkable() {
        return true;
    }
}
