/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */


package com.queplix.core.client.frames.mainframe;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author dmitry.antonov
 */
public class MainToolbarBuilderFactory {
    
    private static final MainToolbarBuilderFactory instance = 
        new MainToolbarBuilderFactory();
    
    private final Map builders = new HashMap();
    
    public static MainToolbarBuilderFactory getInstance() {
        return instance;
    }
    
    /** Creates a new instance of MainToolbarBuilderFactory */
    private MainToolbarBuilderFactory() {
    }
    
    public void addBuilder(MainToolbarBuilder builder) {
        String[] controlNames = builder.getSupportedControls();
        for (int i = 0; i < controlNames.length; i++) {
            builders.put(controlNames[i], builder);
        }
    }
    
    public void removeBuilder(MainToolbarBuilder builder) {
        builders.values().remove(builder);
    }
    
    public MainToolbarBuilder getBuilder(String controlName) {
        return (MainToolbarBuilder) builders.get(controlName);
    }
    
}
