/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.frames.mainframe.impl;

/**
 * This class is needed to narrow mediator related interfaces and specify the command to be sent to objects.
 * Encapsulate form command data.
 *
 * @author Sergey Kozmin
 * @since 31.10.2006, 14:11:54
 */
abstract class GridCommand {
    public static final int SET_GRID_DATA = 0;
    public static final int SET_ROW_DATA = 1;
    public static final int CLEAR_SELECTED_RECORD = 2;

    /**
     * one of the grid command (listed above).
     */
    private int commandID;

    public GridCommand(int commandID) {
        this.commandID = commandID;
    }

    public int getCommandID() {
        return commandID;
    }
}
