/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.frames.mainframe.impl;

import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.FocusMeta;
import com.queplix.core.client.app.vo.MetaData;
import com.queplix.core.client.app.vo.SubFocusMeta;
import com.queplix.core.client.app.vo.TabMeta;
import com.queplix.core.client.common.event.EventSource;
import com.queplix.core.client.common.ui.WindowHelper;
import com.queplix.core.client.common.ui.resizable.ResizableLazyDeckPanel;
import com.queplix.core.client.controls.grid.QGrid;

/**
 * Postfix GA - Grid Area.
 * On focus change you should select corresponding FocusGA in this class to show correct contents.
 * This MainFrameGA contains array of FocusGA.
 * Class FocusGA contains array of SubFocusGA.
 * Class SubFocusGA contains array of TabGA.
 * Class TabGA contains array of QGrid.
 *
 * @author Aliaksandr Melnik
 * @since 19 Oct 2006
 */
class MainFrameGA extends ResizableLazyDeckPanel {

    // -------------------- public events ------------------------
    public static interface Events extends FocusGA.Events {
    }

    private EventSource eventSource = new EventSource(this);

    public EventSource getEventSource() {
        return eventSource;
    }
    
    // ----------------- end of public events --------------------

    private FocusGA[] focusesGA;
    private FocusMeta[] focusesMeta;

    public MainFrameGA(MetaData appMetaData) {
        super(appMetaData.getFocuses().length);
        WindowHelper.disableSelection(this.getElement());
        focusesMeta = appMetaData.getFocuses();
        focusesGA = new FocusGA[focusesMeta.length];

        if(focusesMeta.length > 0) {
            showWidget(0);
        }
    }

    public FocusGA[] getFocusesGA() {
        return focusesGA;
    }

    public void performCommand(GridCommand command, FamgMeta.Index formID) {
        focusesGA[formID.focus].performCommand(command, formID);
    }

    protected void createCard(int index) {
        focusesGA[index] = new FocusGA(focusesMeta[index]);
        focusesGA[index].getEventSource().addEventListener(
                eventSource); // retranslate events
        remove(index);
        insert(focusesGA[index], index);
    }

    void activateFocus(FocusMeta.Index index) {
        showWidget(index.focus);
    }

    void activateSubFocus(SubFocusMeta.Index index) {
        showWidget(index.focus);
        focusesGA[index.focus].activateSubFocus(index);
    }

    void activateTab(TabMeta.Index index) {
        showWidget(index.focus);
        focusesGA[index.focus].activateTab(index);
    }

    void activateGrid(FamgMeta.Index index) {
        showWidget(index.focus);
        focusesGA[index.focus].activateGrid(index);
    }

    public FocusMeta.Index getSelectedFocusIndex() {
        return focusesMeta[getVisibleWidget()].getIndex();
    }

    public SubFocusMeta.Index getSelectedSubFocusIndex() {
        return focusesGA[getVisibleWidget()].getSelectedSubFocusIndex();
    }

    public TabMeta.Index getSelectedTabIndex() {
        return focusesGA[getVisibleWidget()].getSelectedTabIndex();
    }

    public FamgMeta.Index getSelectedFormIndex() {
        return focusesGA[getVisibleWidget()].getSelectedFormIndex();
    }

    public void clearAllGrids() {
        for(int i = 0; i < focusesGA.length; i++) {
            if(focusesGA[i] != null) {
                focusesGA[i].clearAllGrids();
            }
        }
    }

    public QGrid getGrid(FamgMeta.Index famgIndex) {
        FocusGA focusGA = focusesGA[famgIndex.focus];
        return focusGA != null ? focusGA.getGrid(famgIndex):null;
    }

    FamgMeta.Index getActiveGridIndex() {
        int activeFocus = getVisibleWidget();
        FamgMeta.Index index = focusesGA[activeFocus].getActiveGridIndex();
        index.focus = activeFocus;
        return index;
    }

    void collectUISettings() {
        for(int i = 0; i < focusesGA.length; i++) {
            if(focusesGA[i] != null) {
                focusesGA[i].collectUISettings();
            }
        }
    }
}
