/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.frames.mainframe.impl;

import com.queplix.core.client.app.vo.PortalConfigMeta;
import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.common.ui.ButtonData;
import com.queplix.core.client.common.ui.EventButtonData;
import com.queplix.core.client.common.ui.Icon;
import com.queplix.core.client.common.ui.IconButton;
import com.queplix.core.client.common.ui.IconData;
import com.queplix.core.client.common.ui.ToolBar;
import com.queplix.core.client.frames.mainframe.MainToolbarBuilder;
import com.queplix.core.client.frames.mainframe.MainToolbarBuilderFactory;

/**
 * MainFrame Tool Bar.
 *
 * @author Sultan Tezadov
 * @since 10 Oct 2006
 */
class MainToolBar extends ToolBar {

    // ----------------- end of public events --------------------

    public static interface Indicator {
        ButtonData IDLE = new ButtonData(null, "Idle",
                "toolbar/indicator_idle.gif");
        ButtonData COMMUNICATING = new ButtonData(null, "Communicating",
                "toolbar/indicator_communicating.gif");
        ButtonData WORKING = new ButtonData(null, "Working",
                "toolbar/indicator_working.gif");
    }


    private Icon indicator;

    public MainToolBar(PortalConfigMeta.MainToolbarMeta meta) {
        String[] controls = meta.getControls();
        for (int i = 0; i < controls.length; i++) {
            MainToolbarBuilder builder = MainToolbarBuilderFactory.getInstance().
                                         getBuilder(controls[i]);
            if (builder != null) {
                builder.buildControl(this, controls[i]);
            }
        }
        indicator = addIcon(Indicator.IDLE, true);
        ButtonData logoData = new ButtonData(null, "http://www.queplix.com",
                "common/queweb_logo.gif");
        addButton(com.queplix.core.client.frames.mainframe.MainFrameLinkEvents.OPEN_QUEPLIX_SITE, logoData, false);
    }

    public void setIndicatorState(ButtonData state) {
        indicator.setIconState(state);
    }

}
