/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.frames.mainframe.impl;

/**
 * Implements the command, that should tell form to turn to specified state.
 *
 * @author Sergey Kozmin
 * @since 31.10.2006, 16:29:43
 */
class TurnFormToStateCommand extends FormCommand {
    private final static int COMMAND_TYPE = TURN_FORM_TO_STATE;
    /**
     * one of {@link com.queplix.core.client.controls.form.QFormState#EDIT_STATE}
     */
    private int formState;

    /**
     * Contruct the command with the given search status.
     *
     * @param formState one of {@link com.queplix.core.client.controls.form.QFormState#EDIT_STATE}
     */
    public TurnFormToStateCommand(int formState) {
        super(COMMAND_TYPE);
        this.formState = formState;
    }

    public int getFormState() {
        return formState;
    }
}
