/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.integrator;

import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.FieldMeta;
import com.queplix.core.client.app.vo.FocusMeta;
import com.queplix.core.client.app.vo.MetaData;
import com.queplix.core.client.app.vo.SubFocusMeta;
import com.queplix.core.client.app.vo.TabMeta;
import com.queplix.core.client.app.vo.uisettings.DialogUISettings;
import com.queplix.core.client.app.vo.uisettings.FormUISettings;
import com.queplix.core.client.app.vo.uisettings.GridUISettings;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.integrator.security.User;
import com.queplix.core.integrator.security.WebLoginManager;
import com.queplix.core.modules.config.ejb.UserPropertyManagerLocal;
import com.queplix.core.modules.config.utils.DialogSetting;
import com.queplix.core.modules.config.utils.FormSettingDefImpl;
import com.queplix.core.modules.config.utils.GridSettingDefImpl;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

/**
 * Contains fucntions to manage user UI settings
 *
 * @author Sergey Kozmin
 * @since 01.02.2007
 */
public class UserSettingsManager {

    public static void saveUserUISettings(MetaData meta,
                                          HttpServletRequest request) {
        if(meta != null) {
            ServletContext ctx = request.getSession().getServletContext();
            UserPropertyManagerLocal propertiesMrg = IntegratorHelper
                    .getActionContext(ctx).getUserPropertyManager();
            LogonSession ls = WebLoginManager.getLogonSession(request);
            User user = ls.getUser();
            propertiesMrg.deleteDialogUISettings(user);
            propertiesMrg.deleteGridSettings(user);
            propertiesMrg.deleteFormSettings(user);
            DialogSettingsWrapper wrp = new DialogSettingsWrapper();
            GridSettingDefImpl gsw = new GridSettingDefImpl();
            FormSettingDefImpl fsw = new FormSettingDefImpl();
            //update all saveable settings
            for(FocusMeta focusMeta : meta.getFocuses()) {
                for(SubFocusMeta subFocusMeta : focusMeta.getSubFocuses()) {
                    for(TabMeta tabMeta : subFocusMeta.getTabs()) {
                        for(FamgMeta famgMeta : tabMeta.getFamgs()) {
                            for(FieldMeta fieldMeta : famgMeta.getForm()
                                    .getEntityMeta().getFields()) {
                                DialogUISettings set = fieldMeta
                                        .getUISettings();
                                if(set != null && (set.isPositionSet() || set
                                        .isSizeSet())) {
                                    wrp.initialize(set, famgMeta.getFormID(),
                                            fieldMeta.getFieldID());
                                    propertiesMrg.updateDialogUISettings(user,
                                            wrp);
                                }
                            }
                            GridUISettings gridSets = famgMeta.getGrid()
                                    .getUISettings();
                            if(gridSets != null && (gridSets.isPageSizeSet()
                                    || gridSets.isAnyColumnWidthSet()
                                    || gridSets.isCounterOn())) {
                                gsw.initialize(famgMeta.getFormID(),
                                        gridSets.isCounterOn(),
                                        gridSets.getPageSize(),
                                        gridSets.getColumnWidths());
                                propertiesMrg.updateGridSettings(user, gsw);
                            }
                            FormUISettings formSets = famgMeta.getForm()
                                    .getUISettings();
                            if(formSets != null) {
                                fsw.initialize(famgMeta.getFormID(),
                                        formSets.isMinimized());
                                propertiesMrg.updateFormSettings(user, fsw);
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalArgumentException(
                    "Could not save user UI settings. Application metadata could not be a null object. ");
        }
    }

    private static final class DialogSettingsWrapper implements DialogSetting {
        private DialogUISettings dialogSettings;
        private String formId;
        private String fieldId;

        public void initialize(DialogUISettings dialogSettings, String formId,
                               String fieldId) {
            this.fieldId = fieldId;
            this.formId = formId;
            this.dialogSettings = dialogSettings;
        }

        public String getFormId() {
            return formId;
        }

        public String getFieldId() {
            return fieldId;
        }

        public int getLeft() {
            return dialogSettings.getLeft();
        }

        public int getTop() {
            return dialogSettings.getTop();
        }

        public int getWidth() {
            return dialogSettings.getWidth();
        }

        public int getHeight() {
            return dialogSettings.getHeight();
        }
    }
}
