/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eqlext.www;

import com.queplix.core.utils.SystemHelper;
import com.queplix.core.utils.www.AbstractServlet;

import javax.servlet.http.HttpServletRequest;

/**
 * Base class for GetRecords / SetRecords EJB front-ends.
 *
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:44 $
 */
public abstract class AbstractRecordServlet
        extends AbstractServlet {

    // =============================================================== Constants

    private static final String METHOD_HTTP_HEADER = "METHOD";
    private static final String ROBUST_CALL = "ROBUST";
    private static final String FAST_CALL = "FAST";

    // ================================================================= Methods

    /**
     * Checks for the 'fast EJB call' mode.
     * Default is 'fast' EJB call (no debug info, no extra variables).
     * 'Robust' EJB call is used if the specific HTTP header is found.
     *
     * @param request HTTP request
     * @return true for fast EJB call
     */
    protected boolean isFastcall(HttpServletRequest request) {

        if(!SystemHelper.isProductionMode()) {
            // We'are in debug mode...
            return false;
        }

        String method = request.getHeader(METHOD_HTTP_HEADER);
        return (method == null || !method.equalsIgnoreCase(ROBUST_CALL));
    }

}
