/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.security.www;

import com.queplix.core.integrator.security.SecurityException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Web login module with cookie support.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:56 $
 */
public class CookieWebLoginModule {

    // cookie name
    public static final String COOKIE_NAME = "qxcookie";

    // cookie max age
    public static final int COOKIE_MAX_AGE = 604800;

    // cookie data separator
    public static final String COOKIE_SEPARATOR = ":";

    /*
     * No javadoc
     * @see WebLoginModule#doCallWelcomePage
     */
    protected String doCallWelcomePage(HttpServletRequest request,
                                       HttpServletResponse response)
            throws SecurityException, ServletException {
        throw new IllegalStateException("Obsolete security system. ");
        /*// Call super method.
        String ret = super.doCallWelcomePage( request, response );

        // Create new cookie.
        LogonSession ls = WebLoginManager.getLogonSession( request );
        StringBuffer sb = new StringBuffer();
        sb.append( ls.getUser().getLoginName() );
        sb.append( COOKIE_SEPARATOR );
        sb.append( ls.getUser().getUserTypeID() );
        sb.append( COOKIE_SEPARATOR );
        sb.append( ls.getRole().getRoleID() );
        sb.append( COOKIE_SEPARATOR );
        sb.append( request.getRemoteAddr() );

        Cookie cookie = new Cookie( COOKIE_NAME, sb.toString() );
        cookie.setMaxAge( COOKIE_MAX_AGE );
        cookie.setVersion( 0 );
        response.addCookie( cookie );

        if( getLogger().isDebugEnabled() ) {
            DEBUG( "New QX cookie created: " + cookie );
        }

        return ret;*/
    }
}
